/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.integrator;

import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigQueueNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.property.integrator.IVWPanelInterface;
import filenet.vw.toolkit.admin.property.integrator.VWAdaptorInfo;
import filenet.vw.toolkit.admin.property.integrator.VWConfigurationPanel;
import filenet.vw.toolkit.admin.property.integrator.VWGeneralPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VWNewComponentDialog
extends VWModalDialog
implements ActionListener,
IVWFrameInterface {
    private static final String PANEL_GENERAL = "General";
    private static final String PANEL_CONFIGURATION = "Configuration";
    private static int MAX_PANEL_INDEX = 1;
    private IVWPanelInterface[] m_panelList = null;
    private int m_nPanelIndex = 0;
    private VWConfigRegionNode m_regionNode = null;
    private VWConfigQueueNode m_newQueue = null;
    private VWAdaptorInfo m_adaptorInfo = null;
    private JTextArea m_instructionsArea = null;
    private JPanel m_mainPanel = null;
    private JLabel m_instructionHiddenLabel = null;
    private CardLayout m_cardLayout = null;
    private VWGeneralPanel m_generalPanel = null;
    private VWConfigurationPanel m_configurationPanel = null;
    private JButton m_backButton = null;
    private JButton m_nextButton = null;
    private JButton m_finishButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;

    public VWNewComponentDialog(Frame parent, VWConfigRegionNode regionNode, VWSystemConfiguration vwSystemConfiguration) {
        super(parent);
        this.m_regionNode = regionNode;
        this.m_adaptorInfo = new VWAdaptorInfo();
        this.createControls(vwSystemConfiguration);
        this.setLocationRelativeTo(parent);
    }

    public VWConfigQueueNode getQueueNode() {
        return this.m_newQueue;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object.equals(this.m_backButton)) {
            this.moveBack();
        } else if (object.equals(this.m_nextButton)) {
            this.moveNext();
        } else if (object.equals(this.m_finishButton)) {
            try {
                IVWPanelInterface panel = this.m_panelList[this.m_nPanelIndex];
                panel.checkForErrors();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
                return;
            }
            try {
                this.m_newQueue = this.m_adaptorInfo.createQueue(this.m_generalPanel.getName(), this.m_generalPanel.getDescription(), this.m_regionNode);
                if (this.m_newQueue != null) {
                    this.setVisible(false);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
            }
        } else if (object.equals(this.m_cancelButton)) {
            this.exitDialog();
        } else if (object.equals(this.m_helpButton)) {
            this.showHelp();
        }
    }

    public void releaseResources() {
        if (this.m_panelList != null) {
            for (int i = 0; i < this.m_panelList.length; ++i) {
                this.m_panelList[i] = null;
            }
            this.m_panelList = null;
        }
        this.m_regionNode = null;
        this.m_adaptorInfo = null;
        this.m_mainPanel = null;
        this.m_cardLayout = null;
        if (this.m_instructionHiddenLabel != null) {
            this.m_instructionHiddenLabel.removeAll();
            this.m_instructionHiddenLabel = null;
        }
        if (this.m_instructionsArea != null) {
            this.m_instructionsArea.removeAll();
            this.m_instructionsArea = null;
        }
        if (this.m_generalPanel != null) {
            this.m_generalPanel.releaseResources();
            this.m_generalPanel = null;
        }
        if (this.m_configurationPanel != null) {
            this.m_configurationPanel.releaseResources();
            this.m_configurationPanel = null;
        }
        if (this.m_backButton != null) {
            this.m_backButton.removeActionListener(this);
            this.m_backButton.removeAll();
            this.m_backButton = null;
        }
        if (this.m_nextButton != null) {
            this.m_nextButton.removeActionListener(this);
            this.m_nextButton.removeAll();
            this.m_nextButton = null;
        }
        if (this.m_finishButton != null) {
            this.m_finishButton.removeActionListener(this);
            this.m_finishButton.removeAll();
            this.m_finishButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.removeAll();
    }

    public void windowClosing(WindowEvent event) {
        this.exitDialog();
    }

    private void createControls(VWSystemConfiguration vwSystemConfiguration) {
        try {
            this.setTitle(VWResource.AddComponentQueueWizardTitle);
            Dimension dim = VWStringUtils.stringToDimension("665,445");
            if (dim == null) {
                dim = new Dimension(650, 400);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.setDefaultCloseOperation(0);
            this.getContentPane().setLayout(new BorderLayout(4, 4));
            this.m_instructionsArea = new JTextArea(2, 2);
            this.m_instructionsArea.setEditable(false);
            this.m_instructionsArea.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_instructionsArea.setFocusable(false);
            this.m_instructionHiddenLabel = new JLabel();
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_instructionsArea), "Center");
            panel.add((Component)this.m_instructionHiddenLabel, "After");
            this.getContentPane().add((Component)panel, "First");
            this.getContentPane().add((Component)this.getMainPanel(vwSystemConfiguration), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel(VWSystemConfiguration vwSystemConfiguration) {
        try {
            this.m_cardLayout = new CardLayout();
            this.m_mainPanel = new JPanel(this.m_cardLayout);
            this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.m_panelList = new IVWPanelInterface[MAX_PANEL_INDEX + 1];
            this.m_nPanelIndex = 0;
            this.m_generalPanel = new VWGeneralPanel(this.m_adaptorInfo);
            this.m_mainPanel.add((Component)this.m_generalPanel, PANEL_GENERAL);
            this.m_panelList[0] = this.m_generalPanel;
            this.m_instructionsArea.setText(this.m_generalPanel.getInstructions());
            VWAccessibilityHelper.setAccessibility(this.m_instructionHiddenLabel, this, this.m_instructionsArea.getText(), this.m_instructionsArea.getText());
            this.m_configurationPanel = new VWConfigurationPanel(this, this.m_adaptorInfo, this.m_regionNode.getSessionInfo(), vwSystemConfiguration);
            this.m_mainPanel.add((Component)this.m_configurationPanel, PANEL_CONFIGURATION);
            this.m_panelList[1] = this.m_configurationPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_mainPanel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new FlowLayout());
            this.m_backButton = new JButton(VWResource.Back);
            panel.add(this.m_backButton);
            this.m_backButton.setEnabled(false);
            this.m_backButton.setFocusable(this.m_backButton.isEnabled());
            this.m_backButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_backButton, this, VWResource.Back, VWResource.Back);
            this.m_backButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_nextButton = new JButton(VWResource.Next);
            panel.add(this.m_nextButton);
            this.m_nextButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_nextButton, this, VWResource.Next, VWResource.Next);
            this.m_nextButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_finishButton = new JButton(VWResource.Finish);
            panel.add(this.m_finishButton);
            this.m_finishButton.setEnabled(false);
            this.m_finishButton.setFocusable(this.m_finishButton.isEnabled());
            this.m_finishButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_finishButton, this, VWResource.Finish, VWResource.Finish);
            this.m_nextButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            panel.add(this.m_cancelButton);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.Cancel, VWResource.Cancel);
            this.m_nextButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_helpButton = new JButton(VWResource.Ellipse.toString(VWResource.Help));
            panel.add(this.m_helpButton);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.Help, VWResource.Help);
            this.m_nextButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private void moveBack() {
        if (this.m_panelList != null && this.m_nPanelIndex > 0) {
            this.m_cardLayout.previous(this.m_mainPanel);
            --this.m_nPanelIndex;
            IVWPanelInterface panel = this.m_panelList[this.m_nPanelIndex];
            this.m_instructionsArea.setText(panel.getInstructions());
            VWAccessibilityHelper.setAccessibility(this.m_instructionHiddenLabel, this, this.m_instructionsArea.getText(), this.m_instructionsArea.getText());
            if (this.m_nPanelIndex == 0) {
                this.m_backButton.setEnabled(false);
                this.m_backButton.setFocusable(false);
            } else {
                this.m_backButton.setEnabled(true);
                this.m_backButton.setFocusable(true);
            }
            this.m_nextButton.setEnabled(true);
            this.m_nextButton.setFocusable(true);
            this.m_finishButton.setEnabled(false);
            this.m_finishButton.setFocusable(false);
            if (panel.getInitialFocusComponent() != null) {
                panel.getInitialFocusComponent().requestFocus();
            }
        }
    }

    private void moveNext() {
        if (this.m_panelList != null && this.m_nPanelIndex < MAX_PANEL_INDEX) {
            IVWPanelInterface panel = this.m_panelList[this.m_nPanelIndex];
            try {
                panel.checkForErrors();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
                return;
            }
            this.m_cardLayout.next(this.m_mainPanel);
            ++this.m_nPanelIndex;
            panel = this.m_panelList[this.m_nPanelIndex];
            this.m_instructionsArea.setText(panel.getInstructions());
            VWAccessibilityHelper.setAccessibility(this.m_instructionHiddenLabel, this, this.m_instructionsArea.getText(), this.m_instructionsArea.getText());
            if (this.m_nPanelIndex == MAX_PANEL_INDEX) {
                this.m_nextButton.setEnabled(false);
                this.m_nextButton.setFocusable(this.m_nextButton.isEnabled());
                this.m_finishButton.setEnabled(true);
                this.m_finishButton.setFocusable(this.m_finishButton.isEnabled());
            } else {
                this.m_nextButton.setEnabled(true);
                this.m_nextButton.setFocusable(this.m_nextButton.isEnabled());
                this.m_finishButton.setEnabled(false);
                this.m_finishButton.setFocusable(this.m_finishButton.isEnabled());
            }
            this.m_backButton.setEnabled(true);
            this.m_backButton.setFocusable(this.m_backButton.isEnabled());
            if (panel.getInitialFocusComponent() != null) {
                panel.getInitialFocusComponent().requestFocus();
            }
        }
    }

    private void showHelp() {
        String helpPage = VWHelp.Help_Process_Config + "bpfc084.htm#";
        String label = "";
        switch (this.m_nPanelIndex) {
            case 0: {
                label = "specify_general";
                break;
            }
            case 1: {
                label = "select_adaptor";
            }
        }
        VWHelp.displayPage(helpPage + label);
    }

    private void exitDialog() {
        try {
            Toolkit.getDefaultToolkit().beep();
            int nReply = JOptionPane.showConfirmDialog(this, VWResource.CancelMessage, VWResource.ErrorMessage, 0, 3);
            if (nReply == 1) {
                return;
            }
            this.setVisible(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

